using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class FRAGMENT_ANALYSISDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public FRAGMENT_ANALYSISDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public FRAGMENT_ANALYSIS GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 FRAGMENT_ANALYSIS_ID)
		{
			FRAGMENT_ANALYSIS objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_FRAGMENT_ANALYSIS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, FRAGMENT_ANALYSIS_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<FRAGMENT_ANALYSIS> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<FRAGMENT_ANALYSIS> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_FRAGMENT_ANALYSIS_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public List<FRAGMENT_ANALYSIS> GetItemsByActivity(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            List<FRAGMENT_ANALYSIS> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_FRAGMENT_ANALYSIS_getitemsByActivity(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, FRAGMENT_ANALYSIS objSave)
		{
			Int32? objReturn = objSave.FRAGMENT_ANALYSIS_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_FRAGMENT_ANALYSIS_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.BSO_NUMBER, objSave.COMMENT_TEXT, objSave.CREATED, objSave.CREATEDBY, objSave.DIMENSION_UNITS, ref objReturn, objSave.FRAGMENT_DESCR, objSave.FRAGMENT_HEIGHT_MEASURE, objSave.FRAGMENT_ID_NUMBER, objSave.FRAGMENT_LENGTH_MEASURE, objSave.FRAGMENT_MASS_MEASURE, objSave.FRAGMENT_PROD_EVENT_DATE, objSave.FRAGMENT_RADIOACTIVE_RESULT, objSave.FRAGMENT_RADIOACTIVE_TEST_IND, objSave.FRAGMENT_WIDTH_MEASURE, objSave.LAB_ID_NUMBER, objSave.LAB_NAME, objSave.LAB_ORDER_ID, objSave.LAB_REPORT_DATE, objSave.LAB_UID_NUMBER, objSave.MASS_UNITS, objSave.METALS_LAB_CODE, objSave.RESULT_ACKNOWLEDGE_DATE, objSave.RESULT_ACKNOWLEDGE_FLAG, objSave.TESTING_RESULT_TEXT, objSave.TISSUE_RESULT_TEXT, objSave.TISSUE_SENT_DATE, objSave.TISSUE_SENT_FLAG, objSave.UPDATED, objSave.UPDATEDBY, objSave.WKF_CASE_ACTIVITY_ID);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 FRAGMENT_ANALYSIS_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_FRAGMENT_ANALYSIS_delete(CURRENT_USER, CURRENT_REGISTRY_ID, FRAGMENT_ANALYSIS_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
